Ext.data.JsonP.sol_common_monitoring_as_analyzers_ValueAnalyzer({"tagname":"class","name":"sol.common_monitoring.as.analyzers.ValueAnalyzer","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.js","href":"lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.html#sol-common_monitoring-as-analyzers-ValueAnalyzer"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.02.000"],"eloas":true,"requires":["sol.common.SordUtils","sol.common.StringUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"action","tagname":"cfg","owner":"sol.common_monitoring.as.analyzers.ValueAnalyzer","id":"cfg-action","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common_monitoring.as.analyzers.ValueAnalyzer","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"values","tagname":"cfg","owner":"sol.common_monitoring.as.analyzers.ValueAnalyzer","id":"cfg-values","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"analyze","tagname":"method","owner":"sol.common_monitoring.as.analyzers.ValueAnalyzer","id":"method-analyze","meta":{}},{"name":"checkReferenceValues","tagname":"method","owner":"sol.common_monitoring.as.analyzers.ValueAnalyzer","id":"method-checkReferenceValues","meta":{"private":true}},{"name":"compare","tagname":"method","owner":"sol.common_monitoring.as.analyzers.ValueAnalyzer","id":"method-compare","meta":{"private":true}},{"name":"exists","tagname":"method","owner":"sol.common_monitoring.as.analyzers.ValueAnalyzer","id":"method-exists","meta":{"private":true}},{"name":"getValue","tagname":"method","owner":"sol.common_monitoring.as.analyzers.ValueAnalyzer","id":"method-getValue","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"isEmpty","tagname":"method","owner":"sol.common_monitoring.as.analyzers.ValueAnalyzer","id":"method-isEmpty","meta":{"private":true}},{"name":"noop","tagname":"method","owner":"sol.common_monitoring.as.analyzers.ValueAnalyzer","id":"method-noop","meta":{"private":true}},{"name":"notEmpty","tagname":"method","owner":"sol.common_monitoring.as.analyzers.ValueAnalyzer","id":"method-notEmpty","meta":{"private":true}}],"code_type":"ext_define","id":"class-sol.common_monitoring.as.analyzers.ValueAnalyzer","short_doc":"Analyze a sord for spezified values. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common_monitoring.as.analyzers.ValueAnalyzer</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.html#sol-common_monitoring-as-analyzers-ValueAnalyzer' target='_blank'>lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.js</a></div></pre><div class='doc-contents'><p>Analyze a sord for spezified values.</p>\n\n<p>Each of the spezified values has to be meet.</p>\n\n<p>Each value has to define a <code>type</code> and a <code>key</code> (see <a href=\"#!/api/sol.common.SordUtils-method-getValue\" rel=\"sol.common.SordUtils-method-getValue\" class=\"docClass\">sol.common.SordUtils.getValue</a>)</p>\n\n<h1>Value definitions</h1>\n\n<p>Check if a field exists</p>\n\n<pre><code>{ type: \"GRP\", key: \"STATUS\", exists: true }\n</code></pre>\n\n<p>Check if a field has any value</p>\n\n<pre><code>{ type: \"GRP\", key: \"STATUS\", notEmpty: true }\n</code></pre>\n\n<p>Check if a field is empty</p>\n\n<pre><code>{ type: \"GRP\", key: \"STATUS\", isEmpty: true }\n</code></pre>\n\n<p>Compare field content to a reference value (with default comparator '==')</p>\n\n<pre><code>{ type: \"GRP\", key: \"STATUS\", referenceValue: \"UPDATE\" }\n</code></pre>\n\n<p>Compare field content to be greater than a reference value (in this case: is the saved ISO date in the map before the sord edit date)</p>\n\n<pre><code>{ type: \"MAP\", key: \"CHECK_ISO\", referenceValue: { type: \"SORD\", key: \"TStamp\" }, comparator: \"&lt;\" }\n</code></pre>\n\n<p>Compare field content with several localized keyword list keys</p>\n\n<pre><code>{ type: \"GRP\", key: \"CONTRACT_STATUS\", localizedKwl: true, referenceValues: [\"D\", \"S\"] }\n</code></pre>\n\n<p>The value analyzer has a spezial type <code>PARENT_MAP</code>. This will try to check the values from a parent elements map.\nTherefore the collector has to return a prefilled context with a <code>parentMap</code> property (like e.g. the <a href=\"#!/api/sol.common_monitoring.as.collectors.ChildrenCollector\" rel=\"sol.common_monitoring.as.collectors.ChildrenCollector\" class=\"docClass\">ChildrenCollector</a> does).\nIf the collector does not return such a property, it will be handled as empty.\nCheck if the parent has a map value STATUS.4711 (key.objId) for the sord with <code>sord.id=4711</code>:</p>\n\n<pre><code>{ type: \"PARENT_MAP\", key: \"STATUS\", notEmpty: true }\n</code></pre>\n\n<h1>Comparisons</h1>\n\n<p>If compared with a reference value, several comparators can be defined.</p>\n\n<p>Supported comparators are:</p>\n\n<ul>\n<li>\"==\" equal (default)</li>\n<li>\">\"  greater</li>\n<li>\">=\" greater or equal</li>\n<li>\"&lt;\"  smaller</li>\n<li>\"&lt;=\" smaller or equal</li>\n</ul>\n\n\n<h1>Context enhancement</h1>\n\n<p>In addition to just check the values, they can be saved in an context object which can then be used in further processing.\nE.g. the <a href=\"#!/api/sol.common_monitoring.as.executors.SimpleExecutor\" rel=\"sol.common_monitoring.as.executors.SimpleExecutor\" class=\"docClass\">SimpleExecutor</a> can use those values in the action definitions.</p>\n\n<pre><code>var analyzer = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common_monitoring.as.analyzers.ValueAnalyzer\" rel=\"sol.common_monitoring.as.analyzers.ValueAnalyzer\" class=\"docClass\">sol.common_monitoring.as.analyzers.ValueAnalyzer</a>\", {\n  action: { type: \"WORKFLOW\", templateId: \"{{ctx.updateWorkflow}}\" },\n  values: [\n    { type: \"MAP\", key: \"UPDATE_WF\", notEmpty: true, toContext: \"updateWorkflow\" }\n  ]\n});\n</code></pre>\n\n<p>In case of a successfull check, the corresponding value will be written to the context object, which can then be used by the following components.</p>\n      <p class='version-tag'>Version: <b>1.02.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-action' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.ValueAnalyzer'>sol.common_monitoring.as.analyzers.ValueAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.html#sol-common_monitoring-as-analyzers-ValueAnalyzer-cfg-action' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.ValueAnalyzer-cfg-action' class='name expandable'>action</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.ValueAnalyzer'>sol.common_monitoring.as.analyzers.ValueAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.html#sol-common_monitoring-as-analyzers-ValueAnalyzer-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.ValueAnalyzer-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;action&quot;, &quot;values&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-values' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.ValueAnalyzer'>sol.common_monitoring.as.analyzers.ValueAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.html#sol-common_monitoring-as-analyzers-ValueAnalyzer-cfg-values' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.ValueAnalyzer-cfg-values' class='name expandable'>values</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-analyze' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.ValueAnalyzer'>sol.common_monitoring.as.analyzers.ValueAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.html#sol-common_monitoring-as-analyzers-ValueAnalyzer-method-analyze' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.ValueAnalyzer-method-analyze' class='name expandable'>analyze</a>( <span class='pre'>sord, ctx</span> ) : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Analyzes an object for matches of set of values. ...</div><div class='long'><p>Analyzes an object for matches of set of values.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>ctx</span> : Object<div class='sub-desc'><p>Context object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-checkReferenceValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.ValueAnalyzer'>sol.common_monitoring.as.analyzers.ValueAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.html#sol-common_monitoring-as-analyzers-ValueAnalyzer-method-checkReferenceValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.ValueAnalyzer-method-checkReferenceValues' class='name expandable'>checkReferenceValues</a>( <span class='pre'>sord, value, ctx</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks, if a specific value is set on the sord. ...</div><div class='long'><p>Checks, if a specific value is set on the sord.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>value</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>ctx</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-compare' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.ValueAnalyzer'>sol.common_monitoring.as.analyzers.ValueAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.html#sol-common_monitoring-as-analyzers-ValueAnalyzer-method-compare' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.ValueAnalyzer-method-compare' class='name expandable'>compare</a>( <span class='pre'>value, referenceValue, comparator</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Compares two values. ...</div><div class='long'><p>Compares two values.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>referenceValue</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>comparator</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-exists' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.ValueAnalyzer'>sol.common_monitoring.as.analyzers.ValueAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.html#sol-common_monitoring-as-analyzers-ValueAnalyzer-method-exists' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.ValueAnalyzer-method-exists' class='name expandable'>exists</a>( <span class='pre'>sord, value, ctx</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks, if the spezified field exists. ...</div><div class='long'><p>Checks, if the spezified field exists.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>value</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>ctx</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.ValueAnalyzer'>sol.common_monitoring.as.analyzers.ValueAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.html#sol-common_monitoring-as-analyzers-ValueAnalyzer-method-getValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.ValueAnalyzer-method-getValue' class='name expandable'>getValue</a>( <span class='pre'>sord, valueCfg, ctx</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves a value dependent on a configuration. ...</div><div class='long'><p>Retrieves a value dependent on a configuration.</p>\n\n<p>If the 'valueCfg' is already a constant value, it will be returned as it is.</p>\n\n<p>If the value from sord.TStamp should be loaded, this function converts it to a legal ISO date.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>valueCfg</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>ctx</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-isEmpty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.ValueAnalyzer'>sol.common_monitoring.as.analyzers.ValueAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.html#sol-common_monitoring-as-analyzers-ValueAnalyzer-method-isEmpty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.ValueAnalyzer-method-isEmpty' class='name expandable'>isEmpty</a>( <span class='pre'>sord, value, ctx</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks, if the spezified field is empty. ...</div><div class='long'><p>Checks, if the spezified field is empty.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>value</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>ctx</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-noop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.ValueAnalyzer'>sol.common_monitoring.as.analyzers.ValueAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.html#sol-common_monitoring-as-analyzers-ValueAnalyzer-method-noop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.ValueAnalyzer-method-noop' class='name expandable'>noop</a>( <span class='pre'></span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>If there is an illegal check configuration, this 'no operation' will be used to void check. ...</div><div class='long'><p>If there is an illegal check configuration, this 'no operation' will be used to void check.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-notEmpty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.ValueAnalyzer'>sol.common_monitoring.as.analyzers.ValueAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.ValueAnalyzer.html#sol-common_monitoring-as-analyzers-ValueAnalyzer-method-notEmpty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.ValueAnalyzer-method-notEmpty' class='name expandable'>notEmpty</a>( <span class='pre'>sord, value, ctx</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks, if the spezified field has any value. ...</div><div class='long'><p>Checks, if the spezified field has any value.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>value</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>ctx</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true}});